@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">
            <div class="container-fluid">
                <div class="page-title-box">
                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Tour Sales Manage</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Tour Sales</a>
                                    </li>
                                    <li class="breadcrumb-item active">Add Tour Sales</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="/finished-tour" enctype="multipart/form-data" method="post">
                                    @csrf
                                    <div class="form-group">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Name</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" readonly value="{{ $data->name }}" name="name" required>
                                            <input class="form-control" type="hidden" value="{{ $data->id }}" name="clientid" required>
                                        </div>
                                    </div>

                                    <h4 class="mt-0 header-title"> Tour Sales</h4>
                                    <div class="row">
                                        <div class="dynamic-table">
                                            <table class="table table-bordered responsive" id="dynamic-table">
                                                <thead>
                                                    <tr>
                                                        <th>Column 1</th>
                                                        <th>Column 2</th>
                                                        <th>Column 3</th>
                                                        <th>Column 4</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @for ($i = 0; $i < $num_rows; $i++)
                                                        <tr>
                                                            <td><input class="form-control" type="Date" name="date[{{ $i }}]">
                                                                <input type="hidden" name="day[{{ $i }}]" value="{{ $i + 1 }}">
                                                            </td>
                                                            <td> Name <input class="form-control" type="text"
                                                                    name="hotel[{{ $i }}] ">
                                                                <br> Contact <input class="form-control" type="text"
                                                                    name="h-contact[{{ $i }}] "><br> Address <input
                                                                    class="form-control" type="text" name="h-address[{{ $i }}] ">
                                                                <br> price<input class="form-control" type="text"
                                                                    name="h-price[{{ $i }}] "> <br>
                                                                <br> Note<input class="form-control" type="text"
                                                                    name="h-note[{{ $i }}] "> <br>
                                                            </td>
                                                            <td>
                                                                <input type="text" class="form-control pac-target-input"
                                                                    name="destination[{{ $i }}][]" placeholder="Destination"
                                                                    autocomplete="off">
                                                                <input type="hidden" name="rowdestination[{{ $i }}]"
                                                                    id="rowdestination[{{ $i }}]" value="">
                                                            </td>
                                                            <td><input class="form-control" type="text" name="spec[{{ $i }}]"></td>
                                                        </tr>
                                                    @endfor
                                                </tbody>
                                            </table>
                                            <button id="add-row">Add Row</button>
                                            <button class="btn btn-primary add-destination">Add Destination</button>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Package</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" placeholder=" " name="package">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for "example-text-input" class="col-sm-2 col-form-label">Price</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" placeholder=" " name="price">
                                        </div>
                                    </div>
                                    <div class="form-group mb-0">
                                        <div>
                                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                                Submit
                                            </button>
                                            <button type="reset" class="btn btn-secondary waves-effect m-l-5">
                                                Cancel
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- end col -->
                </div>
            </div>
            <!-- container-fluid -->
        </div>
        <!-- content -->
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            var i = {{ $num_rows }} - 1; // Initialize i to the number of rows - 1
            var d = {{ $num_rows }};
            
            // ... (other code remains the same)

            // Submit form
            $('form').submit(function() {
                $('input[name^="rowdestination"]').each(function() {
                    var rowDestinations = [];
                    var rowIndex = $(this).attr('id').match(/\[(.*?)\]/)[1];
                    
                    $('input[name^="destination[' + rowIndex + ']"]').each(function() {
                        rowDestinations.push($(this).val());
                    });

                    $(this).val(rowDestinations.join(','));
                });
            });
        });
    </script>
@endsection
